#pragma once

#include <QObject>

#include "slave.h"
#include "signalsslots.h"

//
// TODO:
// ODC GUI portion should probably go through a similar conversion where it uses the RF System instead of the GUI class
// After that references to 'gui' should be changed to 'rfsystem' as well.
// At the moment it's a total misnomer in the context of 4channel...
//

#if defined GUI_1CHANNEL_ODC

	class GUI_1channel_ODC;

#elif defined GUI_1CHANNEL

	class RF_System_1channel;

#elif defined GUI_4CHANNEL

	class RF_System_4channel;

#endif


class EtherCATModule : public QObject
{
	Q_OBJECT

#if defined GUI_1CHANNEL_ODC

	/* 1Channel */
	private:

		GUI_1channel_ODC& gui;

		EtherCATSlave *slave;
		VariablesInput *in;
		VariablesOutput *out;
		EtherCATSignalsSlots *ss;

	public:

		EtherCATModule (GUI_1channel_ODC& gui);

#elif defined GUI_1CHANNEL

	/* 1Channel */
	private:

		RF_System_1channel& gui;

		EtherCATSlave *slave;
		VariablesInput_1channel *in;
		VariablesOutput_1channel *out;
		EtherCATSignalsSlots_1channel *ss;

	public:

		EtherCATModule (RF_System_1channel& gui);

#elif defined GUI_4CHANNEL

	/* 4Channel */
	private:

		RF_System_4channel& gui;

		EtherCATSlave *slave;
		VariablesInput_4channel *in;
		VariablesOutput_4channel *out;
		EtherCATSignalsSlots_4channel *ss;

	public:

		EtherCATModule (RF_System_4channel& gui);

#endif

	/* Shared items */
	public:

		bool enabled = false;

	public slots:

		void setEnabled (bool enabled);

};
